<?php
require "config.php";
if(!isset($_SESSION['user'])) {
	header('location: '.BASE_URL.'login');
	exit;
}
//get all messages from database
$statement = $pdo->prepare("SELECT * FROM tbl_messages WHERE message_owner=? ORDER BY id DESC");
$statement->execute(array($_SESSION['user']['username']));
$total_messages = $statement->rowCount();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="<?=$meta_description_home?>">
    <meta name="author" content="NodeTent">
    <title><?=$meta_title_home?></title>
    <link rel="shortcut icon" href="<?php echo BASE_URL; ?>assets/img/<?=$favicon?>" type="image/x-icon">
    <link href="<?php echo BASE_URL; ?>assets/css/bootstrap.min.css" rel="stylesheet">
    <link href="<?php echo BASE_URL; ?>assets/css/style.css" rel="stylesheet">
	<link href="<?php echo BASE_URL; ?>assets/css/vendor.css" rel="stylesheet">
	<link href="<?php echo BASE_URL; ?>assets/css/custom.css" rel="stylesheet">
</head>
<body>
	<div id="loader_form">
		<div data-loader="circle-side-2"></div>
	</div>
	<div class="container-fluid full-height">
		<div class="row row-height">
			<div class="col-lg-5 content-left cell">
				<div class="content-left-wrapper">
					<div>
						<figure><img src="<?php echo BASE_URL; ?>assets/img/home.svg" alt="" class="img-fluid"></figure>
						<h2>Welcome, <?=$_SESSION['user']['username']?></h2>
						<p>Share your Mystiko link to get responses from your friends. Click on your link to copy to clipboard.</p>
						<p id="username" onclick="copyToClipboard('#username')"><?=BASE_URL.'p/'.$_SESSION['user']['username'];?></p>
						<a onclick="copyToClipboard('#username')" class="btn_1 rounded">Copy to clipboard</a>
						<a onclick="copyToClipboard('#username')" class="btn_1 rounded mobile_btn">Copy to clipboard</a>
					</div>
					<div class="copy">© 2021 Mystiko</div>
				</div>
				<!-- /content-left-wrapper -->
			</div>
			<!-- /content-left -->
			<div class="col-lg-7 content-right cell cell_style">
			    <div class="row">
<?php
if($total_messages>0):
$result = $statement->fetchAll(PDO::FETCH_ASSOC);
foreach ($result as $row){
?>
			
				<div class="col-xl-4 col-lg-6 col-md-6">
					<div class="review_listing">
						<p><?=htmlspecialchars($row['message_content'])?></p>
						<ul class="clearfix">
							<li><small>Published: <?=$row['time']?></small></li>
						</ul>
					</div>
				</div>
<?php }?>
<?php else: ?>
				<div id="wizard_container wizard_container_style">
					<h2>No Messages Yet!</h2>
				</div>
<?php endif; ?>
                </div>
            </div>
		</div>
	</div>
	<script src="<?php echo BASE_URL; ?>assets/js/jquery.min.js"></script>
    <script src="<?php echo BASE_URL; ?>assets/js/vendor.min.js"></script>
	<script src="<?php echo BASE_URL; ?>assets/js/velocity.min.js"></script>
	<script src="<?php echo BASE_URL; ?>assets/js/main.js"></script>
	<script>
	function copyToClipboard(element) {
        var $temp = $("<input>");
        $("body").append($temp);
        $temp.val($(element).text()).select();
        document.execCommand("copy");
        alert("Link Copied To Clipboard!");
        $temp.remove();
	}
	</script>
</body>
</html>